/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.supermartijn642.connectedglass.model.CGConnectedBakedModel;
import com.supermartijn642.connectedglass.model.CGModelData;
import com.supermartijn642.connectedglass.model.CGPaneModelData;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import org.jetbrains.annotations.NotNull;

public class CGConnectedPaneBakedModel
extends CGConnectedBakedModel {
    public CGConnectedPaneBakedModel(BakedModel originalModel) {
        super(originalModel);
    }

    @Override
    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData tileData) {
        return new ModelDataMap.Builder().withInitial(CGModelData.MODEL_PROPERTY, (Object)CGPaneModelData.create((BlockGetter)level, pos, state)).build();
    }

    @Override
    protected BakedQuad remapQuad(BakedQuad quad, CGModelData modelData) {
        int[] nArray;
        Direction quadDirection = quad.m_111306_();
        boolean isUpOrDown = quadDirection == Direction.UP || quadDirection == Direction.DOWN;
        float[] quadCenter = this.getQuadCenter(quad.m_111303_());
        double quadDistance = Math.sqrt(((double)quadCenter[0] - 0.5) * ((double)quadCenter[0] - 0.5) + ((double)quadCenter[2] - 0.5) * ((double)quadCenter[2] - 0.5));
        if (isUpOrDown && modelData instanceof CGPaneModelData) {
            Direction partSide = Direction.m_122372_((float)(quadCenter[0] - 0.5f), (float)0.0f, (float)(quadCenter[2] - 0.5f));
            if (quadDistance < 0.1 ? (quadDirection == Direction.UP ? ((CGPaneModelData)modelData).isAbovePane() : ((CGPaneModelData)modelData).isBelowPane()) : (quadDirection == Direction.UP ? ((CGPaneModelData)modelData).isAboveConnectedTo(partSide) : ((CGPaneModelData)modelData).isBelowConnectedTo(partSide))) {
                return null;
            }
        }
        int[] vertexData = quad.m_111303_();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        if (isUpOrDown || quadDistance > 0.4) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 7;
        } else {
            nArray = this.getUV(modelData == null ? null : modelData.getSideData(quadDirection == Direction.NORTH ? Direction.SOUTH : (quadDirection == Direction.WEST ? Direction.EAST : quadDirection)));
        }
        int[] newUV = nArray;
        CGConnectedPaneBakedModel.adjustVertexDataUV(vertexData, newUV[0], newUV[1], quad.m_173410_(), DefaultVertexFormat.f_85811_);
        return new BakedQuad(vertexData, quad.m_111305_(), quadDirection, quad.m_173410_(), quad.m_111307_());
    }

    private float[] getQuadCenter(int[] vertexData) {
        int vertexSize = DefaultVertexFormat.f_85811_.m_86017_();
        int vertices = vertexData.length / vertexSize;
        int positionOffset = CGConnectedPaneBakedModel.findPositionOffset(DefaultVertexFormat.f_85811_) / 4;
        float averageX = 0.0f;
        float averageY = 0.0f;
        float averageZ = 0.0f;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + positionOffset;
            averageX += Float.intBitsToFloat(vertexData[offset]);
            averageY += Float.intBitsToFloat(vertexData[offset + 1]);
            averageZ += Float.intBitsToFloat(vertexData[offset + 2]);
        }
        return new float[]{averageX /= (float)vertices, averageY /= (float)vertices, averageZ /= (float)vertices};
    }

    private static int findPositionOffset(VertexFormat vertexFormat) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < vertexFormat.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.POSITION) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.m_86023_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a POSITION attribute");
        }
        if (element.m_86041_() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected POSITION attribute to have data type FLOAT");
        }
        if (element.m_86050_() != 12) {
            throw new RuntimeException("Expected POSITION attribute to have 3 dimensions");
        }
        return vertexFormat.getOffset(index);
    }
}

